<?php

namespace Modules\Common\Entities;

use Illuminate\Database\Eloquent\Model;
use Modules\Common\Entities\Relationships\AlertRelationships;
use Modules\Common\Entities\Scopes\AlertScopes;
use Modules\Common\Entities\Traits\Localizable;

class Alert extends Model
{

    /***************************************************************************
     * Traits
     **************************************************************************/
    use AlertRelationships,
        AlertScopes,
        Localizable;

    /***************************************************************************
     * Attributes
     **************************************************************************/
    protected $fillable = [
        'user_id', 'animal_species', 'location_address', 'location_latitude',
        'location_longitude', 'radius',
    ];

    protected $casts = [
        'radius' => 'int',
    ];

    // End of class
}
