<?php

use Faker\Generator as Faker;

use Modules\Common\Entities\Animal;
use Modules\Common\Entities\PremiumCity;
use Modules\Common\Entities\Report;
use Modules\Common\Entities\User;

$factory->define(Report::class, function (Faker $faker) {
    return [
        'user_id' => User::all()->random()->id,
        'location_address' => $faker->address,
        'location_latitude' => $faker->latitude(45, 55),
        'location_longitude' => $faker->longitude(-6, 14),
        'location_zipcode' => $faker->optional()->postcode,
        'location_country' => $faker->randomElement(PremiumCity::COUNTRIES),
        'type' => $faker->randomElement(Report::TYPES),
        'animal_species' => $faker->randomElement(Animal::ANIMAL_SPECIES),
        'animal_condition' => $faker->randomElement(Animal::ANIMAL_CONDITIONS),
        'identification_type' => $faker->optional()->randomElement(Animal::IDENTIFICATION_TYPES),
        'identification_number' => $faker->optional()->isbn10(),
        'final_location' => $faker->text(10),
        'comment' => $faker->optional()->text(60),
        'state' => $faker->randomElement(Report::STATES),
    ];
});
