<?php

use Faker\Generator as Faker;

use Modules\Common\Entities\Place;
use Modules\Common\Entities\PremiumCity;

$factory->define(Place::class, function (Faker $faker) {
    return [
        'name' => $faker->name,
        'type' => $faker->randomElement(Place::TYPES),
        'phone' => $faker->e164PhoneNumber,
        'content' => $faker->optional()->text(60),
        'zipcodes' => $faker->postcode,
        'country' => $faker->randomElement(PremiumCity::COUNTRIES),
        'location_address' => $faker->address,
        'location_latitude' => $faker->latitude,
        'location_longitude' => $faker->longitude,
    ];
});
