<?php

namespace Modules\Common\Database\Seeders\Test;

use Illuminate\Database\Seeder;
use Modules\Common\Entities\PremiumCity;
use Modules\Common\Entities\Report;

class ReportsTestTableSeeder extends Seeder
{
    /**
     * Seed the application's database.
     *
     * @return void
     */
    public function run()
    {
        // Report 1
        factory(Report::class)->create([
            'id' => 1,
            'user_id' => 1,
            'type' => Report::TYPE_FOUND,
            'location_address' => 'Morlanwelz',
            'location_longitude' => 4.239730904725438,
            'location_latitude' => 50.451547404089936,
            'location_zipcode' => '7140',
            'location_country' => PremiumCity::COUNTRY_BELGIUM,
        ]);

        // Report 2
        factory(Report::class)->create([
            'id' => 2,
            'user_id' => 1,
            'location_address' => 'Seneffe',
            'location_longitude' => 4.2570099497625815,
            'location_latitude' => 50.535526021266286,
            'location_zipcode' => '7180',
            'location_country' => PremiumCity::COUNTRY_BELGIUM,
        ]);

        // Report 3
        factory(Report::class)->create([
            'id' => 3,
            'user_id' => 2,
            'location_address' => 'Nivelles',
            'location_longitude' => 4.32966593664374,
            'location_latitude' => 50.603174984113046,
            'location_zipcode' => '1400',
            'location_country' => PremiumCity::COUNTRY_BELGIUM,
        ]);
    }

    // End of class
}
