<?php

namespace Modules\Common\Database\Seeders\Test;

use Illuminate\Database\Seeder;
use Modules\Common\Entities\Place;
use Modules\Common\Entities\PremiumCity;

class PlacesTestTableSeeder extends Seeder
{
    /**
     * Seed the application's database.
     *
     * @return void
     */
    public function run()
    {
        // Place 1
        factory(Place::class)->create([
            'id' => 1,
            'name' => 'Test Police',
            'type' => Place::TYPE_POLICE,
            'phone' => '+32123456789',
            'content' => '',
            'zipcodes' => '7140',
            'country' => PremiumCity::COUNTRY_BELGIUM,
            'location_address' => 'Here 1',
            'location_latitude' => 1,
            'location_longitude' => 2,
        ]);

        // Place 2
        factory(Place::class)->create([
            'id' => 2,
            'name' => 'Test Veterinary',
            'type' => Place::TYPE_VETERINARY,
            'phone' => '+32987654321',
            'content' => 'Extras',
            'zipcodes' => '7180',
            'country' => PremiumCity::COUNTRY_BELGIUM,
            'location_address' => 'Here 2',
            'location_latitude' => 3,
            'location_longitude' => 4,
        ]);
    }

    // End of class
}
