<?php

namespace Modules\Common\Database\Seeders\Test;

use Illuminate\Database\Seeder;

use Modules\Common\Entities\Alert;
use Modules\Common\Entities\Animal;

class AlertsTestTableSeeder extends Seeder
{
    /**
     * Seed the application's database.
     *
     * @return void
     */
    public function run()
    {
        // Alert 1
        factory(Alert::class)->create([
            'id' => 1,
            'user_id' => 1,
            'animal_species' => Animal::ANIMAL_SPECIES_PET_DOG_SMALL,
            'location_address' => 'Morlanwelz',
            'location_longitude' => 4.239730904725438,
            'location_latitude' => 50.451547404089936,
            'radius' => 50,
        ]);

        // Alert 2
        factory(Alert::class)->create([
            'id' => 2,
            'user_id' => 2,
            'animal_species' => Animal::ANIMAL_SPECIES_PET_CAT,
            'location_address' => 'Seneffe',
            'location_longitude' => 4.2570099497625815,
            'location_latitude' => 50.535526021266286,
            'radius' => 5,
        ]);

        // Alert 3
        factory(Alert::class)->create([
            'id' => 3,
            'user_id' => 2,
            'animal_species' => 'pet_dog',
            'location_address' => 'Nivelles',
            'location_longitude' => 4.32966593664374,
            'location_latitude' => 50.603174984113046,
            'radius' => 15,
        ]);
    }

    // End of class
}
