<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Modules\Common\Entities\User;

class AddOrganizationAccountsToUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->json('extras')->nullable()->after('address_is_private');
            $table->string('account_type', 20)->nullable()->default(User::ACCOUNT_TYPE_INDIVIDUAL)->after('extras');
            $table->boolean('is_verified')->default(true)->after('account_type');
            $table->dropUnique(['email']);
            $table->unique(['email', 'account_type']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropUnique(['email', 'account_type']);
            $table->unique('email');
            $table->dropColumn('is_verified');
            $table->dropColumn('account_type');
            $table->dropColumn('extras');
        });
    }

    // End of class
}
