<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

use Modules\Common\Entities\Report;


class AddDeletionReasonToReportsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('reports', function (Blueprint $table) {
            $table->string('deletion_reason', 30)->nullable()->after('state');
            $table->text('deletion_reason_comment')->nullable()->after('deletion_reason');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('reports', function (Blueprint $table) {
            $table->dropColumn('deletion_reason');
            $table->dropColumn('deletion_reason_comment');
        });
    }

    // End of class
}
