<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

use Modules\Common\Entities\Animal;
use Modules\Common\Entities\Report;

class CreateReportsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('reports', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('user_id');

            $table->string('location_address', 180)->nullable();
            $table->decimal('location_latitude', 10, 8);
            $table->decimal('location_longitude', 11, 8);

            $table->string('type', 10)->default(Report::TYPE_FOUND);
            $table->string('animal_species', 30);
            $table->string('animal_condition', 10)->default(Animal::ANIMAL_CONDITION_HEALTHY);

            $table->string('identification_type', 10)->nullable();
            $table->string('identification_number', 40)->nullable();

            $table->string('final_location', 180)->nullable();
            $table->text('comment')->nullable();

            $table->string('state', 10)->default(Report::STATE_WAITING);

            $table->timestamps();

            $table->softDeletes();
        });

        Schema::table('reports', function (Blueprint $table) {
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('reports');
    }
}
