<?php

namespace Modules\Blog\Tests\Feature\Database;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

use Modules\Blog\Entities\Post;
use Modules\Blog\Entities\Tag;

use Schema;

class PostTest extends TestCase
{
    use RefreshDatabase;

    /***************************************************************************
     * Set Up
     **************************************************************************/
    public function setUp(): void
    {
        parent::setUp();

        $this->artisan('db:seed', ['--class' => 'Modules\Blog\Database\Seeders\Test\TestDatabaseSeeder']);
    }

    /***************************************************************************
     * Tests
     **************************************************************************/
    public function testPostsTableHasExpectedColumns()
    {
        $this->assertTrue(
            Schema::hasColumns('posts', [
                'id', 'title', 'slug', 'excerpt', 'body', 'state', 'meta_title',
                'meta_description', 'created_at', 'updated_at',
            ])
        );
    }

    public function testPostBelongsToManyTags()
    {
        $post = Post::find(1);
        $tag = Tag::find(1);
        $otherTag = Tag::find(2);

        $this->assertInstanceOf('Illuminate\Database\Eloquent\Collection', $post->tags);
        $this->assertTrue($post->tags->contains($tag));
        $this->assertTrue($post->tags->contains($otherTag));
    }

    // End of class
}
