<?php

namespace Modules\Blog\Http\Controllers;

use Illuminate\Routing\Controller;

use Modules\Blog\Entities\Post;

class PostController extends Controller
{

    public function index()
    {
        // Get posts
        $posts = Post::published()->latest()->paginate(12);

        // Return view
        return view('blog::index', compact('posts'));
    }

    public function show(Post $post)
    {
        // Get latest posts
        $latestPosts = Post::published()->take(4)->latest()->get();

        // Return view
        return view('blog::show', compact('post', 'latestPosts'));
    }

    // End of class
}
