<?php

use Modules\Blog\Entities\Post;
use Faker\Generator as Faker;

$factory->define(Post::class, function (Faker $faker) {
    $title = $faker->sentence(6, true);
    return [
        'title' => $title,
        'slug' => Str::slug($title),
        'excerpt' => $faker->sentence(24, true),
        'body' => $faker->paragraph(50, true),
        'state' => $faker->randomElement([Post::STATE_PENDING, Post::STATE_PUBLISHED]),
        'created_at' => $faker->dateTimeBetween($startDate = '-2 years', $endDate = '-5 days', $timezone = null),
    ];
});