<?php

namespace Modules\Api\Tests\Feature\Report;

use Modules\Api\Tests\Feature\TestCase;
use Modules\Common\Entities\User;


class AbuseTest extends TestCase
{

    /***************************************************************************
     * Tests
     **************************************************************************/
    public function testStoreAbuseWithUnauthenticated()
    {
        $this->postJson('/api/reports/3/abuses')
            ->assertStatus(401)
            ->assertJson(['message' => 'Unauthenticated.']);
    }

    public function testStoreAbuseSuccessfully()
    {
        $user = User::find(1);

        $payload = [
            'comment' => 'Comment',
            'type' => 'other',
        ];

        $this->actingAs($user, 'api')
            ->postJson('/api/reports/3/abuses', $payload)
            ->assertStatus(201);
    }

    // End of class
}
