<?php

namespace Modules\Api\Tests\Feature;

use Modules\Common\Entities\Place;
use Modules\Common\Entities\PremiumCity;
use Modules\Common\Entities\User;


class PlaceTest extends TestCase
{

    /***************************************************************************
     * Tests
     **************************************************************************/
    public function testGetPlacesWithUnauthenticated()
    {
        $this->getJson('/api/places')
            ->assertStatus(401)
            ->assertJson(['message' => 'Unauthenticated.']);
    }

    public function testGetPlacesWithNoPremium()
    {
        $user = User::find(3);

        $this->actingAs($user, 'api')
            ->getJson('/api/places')
            ->assertStatus(200);
    }

    public function testGetPlacesWithOrganization()
    {
        $user = User::find(1);
        $user->account_type = User::ACCOUNT_TYPE_ORGANIZATION;
        $user->save();

        $this->actingAs($user, 'api')
            ->getJson('/api/places')
            ->assertStatus(200);
    }

    public function testGetPlacesWithOrganizationAccess()
    {
        $user = User::find(1);
        $user->account_type = User::ACCOUNT_TYPE_ACCESS;
        $user->save();

        $this->actingAs($user, 'api')
            ->getJson('/api/places')
            ->assertStatus(200);
    }

    public function testGetPlaces()
    {
        $user = User::find(1);

        $this->actingAs($user, 'api')
            ->getJson('/api/places?zipcode=7140&country=BE')
            ->assertStatus(200)
            ->assertJson([
                'data' => [
                    [
                        'id' => 1,
                        'name' => 'Test Police',
                        'type' => Place::TYPE_POLICE,
                        'phone' => '+32123456789',
                        'content' => '',
                        'location' => [
                            'address' => 'Here 1',
                            'latitude' => '1.00000000',
                            'longitude' => '2.00000000',
                            'zipcode' => '',
                            'country' => '',
                        ],
                    ],
                ],
            ]);
    }

    // End of class
}
