<?php

namespace Modules\Api\Tests\Feature\Auth;

use Modules\Api\Tests\Feature\TestCase;


class RegisterTest extends TestCase
{

    /***************************************************************************
     * Tests
     **************************************************************************/
    public function testRegisterWithBadMethod()
    {
        $response = $this->get('/api/auth/register');

        $response->assertStatus(405);
    }

    public function testRegisterWithUnprocessableEntity()
    {
        $response = $this->postJson('/api/auth/register');

        $response->assertStatus(422);
    }

    public function testRegisterWithExistingEmail()
    {
        $email = 'perfect.guy@example.org';

        $payload = [
            'email' => $email,
            'password' => 'password',
            'first_name' => 'John',
            'last_name' => 'Doe',
        ];

        $this->postJson('/api/auth/register', $payload)
            ->assertStatus(422);
    }

    public function testRegisterSuccessfully()
    {
        $payload = [
            'email' => 'test@example.org',
            'password' => 'password',
            'first_name' => 'John',
            'last_name' => 'Doe',
            'address' => 'Morlanwelz',
            'location_zipcode' => '7140',
            'location_country' => 'be',
            'phone' => '+32483023343',
        ];

        $this->postJson('/api/auth/register', $payload)
            ->assertStatus(201);
    }

    // End of class
}
