<?php

namespace Modules\Api\Tests\Feature\Auth;

use Modules\Api\Tests\Feature\TestCase;


class LoginTest extends TestCase
{

    /***************************************************************************
     * Tests
     **************************************************************************/
    public function testLoginWithBadMethod()
    {
        $response = $this->get('/api/auth/login');

        $response->assertStatus(405);
    }

    public function testLoginWithoutCredentials()
    {
        $response = $this->postJson('/api/auth/login');

        $response->assertStatus(422);
    }

    public function testLoginWithBadCredentials()
    {
        $payload = [
            'email' => 'perfect.guy@example.org',
            'password' => 'wrong_password',
        ];

        $response = $this->postJson('/api/auth/login', $payload);

        $response->assertStatus(401);
    }

    public function testLoginWithBlockedAccount()
    {
        $payload = [
            'email' => 'blocked.account@example.org',
            'password' => 'password',
        ];

        $response = $this->postJson('/api/auth/login', $payload);

        $response->assertStatus(403);
    }

    public function testLoginSuccessfully()
    {
        $payload = [
            'email' => 'perfect.guy@example.org',
            'password' => 'password',
        ];

        $this->postJson('/api/auth/login', $payload)
            ->assertStatus(200)
            ->assertJsonStructure([
                'data' => [
                    'token_type',
                    'access_token',
                    'expires_at',
                ],
            ]);
    }

    // End of class
}
