<?php

namespace Modules\Api\Tests\Feature\Account;

use Modules\Api\Tests\Feature\TestCase;
use Modules\Common\Entities\Animal;
use Modules\Common\Entities\User;


class RegisteredAnimalTest extends TestCase
{

    /***************************************************************************
     * Tests
     **************************************************************************/
    public function testGetRegisteredAnimalsWithUnauthenticated()
    {
        $this->getJson('/api/account/registered_animals')
            ->assertStatus(401)
            ->assertJson(['message' => 'Unauthenticated.']);
    }

    public function testGetRegisteredAnimalsWithNoPremium()
    {
        $user = User::find(3);

        $this->actingAs($user, 'api')
            ->getJson('/api/account/registered_animals')
            ->assertStatus(403)
            ->assertJson(['error' => 'account_not_premium']);
    }

    public function testGetRegisteredAnimalsWithOrganization()
    {
        $user = User::find(1);
        $user->account_type = User::ACCOUNT_TYPE_ORGANIZATION;
        $user->save();

        $this->actingAs($user, 'api')
            ->getJson('/api/account/registered_animals')
            ->assertStatus(403)
            ->assertJson(['error' => 'account_type_not_allowed']);
    }

    public function testGetRegisteredAnimalsWithOrganizationAccess()
    {
        $user = User::find(1);
        $user->account_type = User::ACCOUNT_TYPE_ACCESS;
        $user->save();

        $this->actingAs($user, 'api')
            ->getJson('/api/account/registered_animals')
            ->assertStatus(403)
            ->assertJson(['error' => 'account_type_not_allowed']);
    }

    public function testGetRegisteredAnimalsSuccessfully()
    {
        $user = User::find(1);

        $this->actingAs($user, 'api')
            ->getJson('/api/account/registered_animals')
            ->assertStatus(200)
            ->assertJson([
                'data' => [
                    [
                        'id' => 1,
                        'name' => 'Medor',
                        'animal_species' => Animal::ANIMAL_SPECIES_PET_DOG_COCKER,
                        'identification_type' => Animal::IDENTIFICATION_TYPE_MICROCHIP,
                        'identification_number' => '1122',
                        'comment' => 'Comment',
                        'images' => [],
                        'thumbnail' => '',
                    ],
                ],
            ]);
    }

    // End of class
}
