<?php

namespace Modules\Api\Tests\Feature\Account;

use Modules\Common\Entities\User;
use Modules\Api\Tests\Feature\TestCase;

use Hash;


class PasswordTest extends TestCase
{

    /***************************************************************************
     * Tests
     **************************************************************************/
    public function testUpdatePasswordWithUnauthenticated()
    {
        $this->putJson('/api/account/password')
            ->assertStatus(401)
            ->assertJson(['message' => 'Unauthenticated.']);
    }

    public function testUpdatePasswordWithBadCredentials()
    {
        $user = User::find(1);

        $payload = [
            'password' => 'wrong_password',
            'new_password' => 'password',
            'new_password_confirmation' => 'password',
        ];

        $this->actingAs($user, 'api')
            ->putJson('/api/account/password', $payload)
            ->assertStatus(422);
    }

    public function testUpdatePasswordWithNotMatch()
    {
        $user = User::find(1);

        $payload = [
            'password' => 'password',
            'new_password' => '12345678',
            'new_password_confirmation' => '12345679',
        ];

        $this->actingAs($user, 'api')
            ->putJson('/api/account/password', $payload)
            ->assertStatus(422);
    }

    public function testUpdatePasswordWithOrganization()
    {
        $user = User::find(1);
        $user->account_type = User::ACCOUNT_TYPE_ORGANIZATION;
        $user->save();

        $payload = [
            'password' => 'password',
            'new_password' => '12345678',
            'new_password_confirmation' => '12345678',
        ];

        $this->actingAs($user, 'api')
            ->putJson('/api/account/password', $payload)
            ->assertStatus(200);
    }

    public function testUpdatePasswordWithOrganizationAccess()
    {
        $user = User::find(1);
        $user->account_type = User::ACCOUNT_TYPE_ACCESS;
        $user->save();

        $payload = [
            'password' => 'password',
            'new_password' => '12345678',
            'new_password_confirmation' => '12345678',
        ];

        $this->actingAs($user, 'api')
            ->putJson('/api/account/password', $payload)
            ->assertStatus(200);
    }

    public function testUpdatePasswordSuccessfully()
    {
        $user = User::find(1);

        $payload = [
            'password' => 'password',
            'new_password' => '12345678',
            'new_password_confirmation' => '12345678',
        ];

        $this->actingAs($user, 'api')
            ->json('put', '/api/account/password', $payload)
            ->assertStatus(200);

        $user->refresh();

        $this->assertTrue(Hash::check('12345678', $user->password));
    }

    // End of class
}
