<?php

namespace Modules\Api\Tests\Feature\Account;

use Modules\Api\Tests\Feature\TestCase;
use Modules\Common\Entities\Animal;
use Modules\Common\Entities\User;


class AlertTest extends TestCase
{

    /***************************************************************************
     * Tests
     **************************************************************************/
    public function testGetAlertsWithUnauthenticated()
    {
        $this->getJson('/api/account/alerts')
            ->assertStatus(401)
            ->assertJson(['message' => 'Unauthenticated.']);
    }

    public function testGetAlertsWithNoPremium()
    {
        $user = User::find(3);

        $this->actingAs($user, 'api')
            ->getJson('/api/account/alerts')
            ->assertStatus(403)
            ->assertJson(['error' => 'account_type_not_allowed']);
    }

    public function testGetAlertsWithOrganization()
    {
        $user = User::find(1);
        $user->account_type = User::ACCOUNT_TYPE_ORGANIZATION;
        $user->save();

        $this->actingAs($user, 'api')
            ->getJson('/api/account/alerts')
            ->assertStatus(200);
    }

    public function testGetAlertsWithOrganizationAccess()
    {
        $user = User::find(1);
        $user->account_type = User::ACCOUNT_TYPE_ACCESS;
        $user->save();

        $this->actingAs($user, 'api')
            ->getJson('/api/account/alerts')
            ->assertStatus(200);
    }

    public function testGetAlertsSuccessfully()
    {
        $user = User::find(1);

        $this->actingAs($user, 'api')
            ->getJson('/api/account/alerts')
            ->assertStatus(200)
            ->assertJson([
                'data' => [
                    [
                        'id' => 1,
                        'animal_species' => Animal::ANIMAL_SPECIES_PET_DOG_SMALL,
                        'location' => [
                            'address' => 'Morlanwelz',
                            'longitude' => 4.23973090,
                            'latitude' => 50.45154740,
                            'zipcode' => '',
                            'country' => '',
                        ],
                        'radius' => 50,
                    ],
                ],
            ]);
    }

    // End of class
}
