<?php

namespace Modules\Api\Http\Services;

use Modules\Common\Entities\Place;


class PlaceService
{

    /***************************************************************************
     * Constants
     **************************************************************************/
    private const MAX_RESULTS = 5;
    private const DEFAULT_RADIUS = 100;

    /***************************************************************************
     * Methods
     **************************************************************************/
    public function index(array $attributes)
    {
        // Prepare query
        $query = Place::take(self::MAX_RESULTS);

        // Apply zipcode filter
        $query = $this->applyZipcodeFilter($attributes, $query);

        // Apply location filter
        $query = $this->applyLocationFilter($attributes, $query);

        // Apply type filter
        $query = $this->applyTypeFilter($attributes, $query);

        // Get places
        $places = $query->get();

        // Return places
        return $places;
    }

    /***************************************************************************
     * Utils
     **************************************************************************/
    private function applyZipcodeFilter(array $attributes, $query)
    {
        // Get zipcode and country
        $zipcode = $attributes['zipcode'] ?? null;
        $country = $attributes['country'] ?? null;

        // Zipcode filter
        if ($zipcode) {
            $query = $query->inZipcodes($zipcode);
        }

        // Country filter
        if ($country) {
            $query = $query->whereCountry($country);
        }

        // Return query
        return $query;
    }

    private function applyLocationFilter(array $attributes, $query)
    {
        // Get location
        $latitude = $attributes['latitude'] ?? null;
        $longitude = $attributes['longitude'] ?? null;

        // If exists then apply filter
        if ($latitude && $longitude) {
            $query = $query->withDistance([
                'latitude' => $latitude,
                'longitude' => $longitude,
            ])->orderBy('location_distance');
        }


        // Return query
        return $query;
    }

    private function applyTypeFilter(array $attributes, $query)
    {
        // Get type
        $type = $attributes['type'] ?? null;

        // If exists then apply filter
        if ($type) {
            $query = $query->whereType($type);
        }

        // Return query
        return $query;
    }

    // End of class
}
