<?php

namespace Modules\Api\Http\Services\Account;

use Modules\Common\Entities\NotificationToken;

use Auth;


class NotificationTokenService
{

    public function store(array $attributes)
    {
        // Retrieve user
        $user = Auth::user();

        // Prepare data
        $attributes['access_token'] = $user->token()->id;

        // Delete old records matching accessToken
        NotificationToken::where('access_token', $attributes['access_token'])->delete();

        // Delete old records matching notificationToken
        NotificationToken::where('token', $attributes['token'])->delete();

        // Create new notification token
        $user->notificationTokens()->create($attributes);
    }

    // End of class
}
