<?php

namespace Modules\Api\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

use Modules\Api\Http\Resources\Location as LocationResource;

class MapReport extends JsonResource
{

    public function toArray($request)
    {
        $author = $this->user->organization;
        return [
            'id' => $this->id,
            'type' => $this->type,
            'location' => [
                'latitude' => $this->location_latitude,
                'longitude' => $this->location_longitude,
            ],
        ];
    }

    // End of class
}
