<?php

namespace Modules\Api\Http\Middleware;

use App;
use Closure;
use Config;

class Localization
{
    private const LANGUAGE_HEADER = 'Content-Language';
    
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  \Closure                 $next
     *
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        // Read the language from the request header
        $locale = $request->header(self::LANGUAGE_HEADER);

        // Fallback language if header not set
        if (!$locale) {
            $locale = Config::get('app.locale');
        }

        // Set the locale language
        App::setLocale($locale);

        // Get the response after the request is done
        $response = $next($request);

        // Set Content Languages header in the response
        $response->headers->set(self::LANGUAGE_HEADER, $locale);

        // Return the response
        return $response;
    }
    
    // End of class
}