<?php

namespace Modules\Api\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Modules\Api\Http\Resources\Places as PlaceCollection;
use Modules\Api\Http\Services\PlaceService;


class PlaceController extends Controller
{

    /***************************************************************************
     * Attributes
     **************************************************************************/
    protected $placeService;

    /***************************************************************************
     * Constructors
     **************************************************************************/
    public function __construct(PlaceService $placeService)
    {
        $this->placeService = $placeService;
    }

    /***************************************************************************
     * Methods
     **************************************************************************/
    public function index(Request $request)
    {
        // Get places
        $places = $this->placeService->index($request->all());

        // Return places
        return new PlaceCollection($places);
    }

    // End of class
}
