<?php

namespace Modules\Api\Http\Controllers\Account;

use Illuminate\Http\Request;

use App\Http\Controllers\Controller;

use Modules\User\Http\Requests\UpdateProfileRequest;
use Modules\Api\Http\Resources\User as UserResource;

class UserController extends Controller
{

    public function index(Request $request)
    {
        // Get current user
        $user = $request->user();

        // Return user
        return new UserResource($user);
    }

    public function update(UpdateProfileRequest $request)
    {
        // Get current user
        $user = $request->user();

        // Validate data
        $validated = $request->validated();

        // Update user
        $user->update($validated);

        // Return updated user
        return new UserResource($user);
    }

    // End of class
}
