<?php

namespace Modules\Api\Http\Controllers\Account;

use App\Http\Controllers\Controller;

use Modules\User\Http\Requests\StoreNotificationTokenRequest;
use Modules\Api\Http\Services\Account\NotificationTokenService;

class NotificationTokenController extends Controller
{

    /***************************************************************************
     * Attributes
     **************************************************************************/
    protected $notificationTokenService;

    /***************************************************************************
     * Constructors
     **************************************************************************/
    public function __construct(NotificationTokenService $notificationTokenService)
    {
        $this->notificationTokenService = $notificationTokenService;
    }

    /***************************************************************************
     * Methods
     **************************************************************************/
    public function store(StoreNotificationTokenRequest $request)
    {
        // Store Notification Token
        $this->notificationTokenService->store($request->validated());

        // Return response
        return response()->json(null, 201);
    }

    // End of class
}
