<?php

namespace Modules\Api\Http\Controllers\Account;

use App\Http\Controllers\Controller;

use Modules\Api\Http\Resources\Reports as ReportCollection;

class DeletedReportController extends Controller
{

    public function index()
    {
        // Get deleted reports of the user
        $reports = auth()->user()->reportsWithMembers()->with('user', 'media')->onlyTrashed()->latest()->paginate(25);

        // Return reports
        return new ReportCollection($reports);
    }

    // End of class
}
