<?php

namespace Modules\Admin\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateTagRequest extends FormRequest
{

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'name' => 'required|string|max:40',
            'slug' => 'required|string|unique:tags,slug,'.$this->id,
        ];
    }

    public function attributes()
    {
        return [
            'name' => __('messages.global.name'),
            'slug' => __('messages.global.slug'),
        ];
    }

    // End of class
}
