<?php

namespace Modules\Admin\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

use Modules\Common\Entities\Animal;
use Modules\Common\Entities\Report;

class UpdateReportRequest extends FormRequest
{

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'user_id'               => ['required', 'numeric'],
            'location_address'      => ['nullable', 'string', 'max:180'],
            'location_zipcode'      => ['nullable', 'string', 'max:20'],
            'location_country'      => ['nullable', 'string', 'max:30'],
            'location_latitude'     => ['required', 'numeric', 'min:-90',  'max:90'],
            'location_longitude'    => ['required', 'numeric', 'min:-180', 'max:180'],
            'type'                  => ['required', Rule::in(Report::TYPES)],
            'animal_species'        => ['required', Rule::in(Animal::ANIMAL_SPECIES)],
            'animal_condition'      => ['required', Rule::in(Animal::ANIMAL_CONDITIONS)],
            'identification_type'   => ['nullable', Rule::in(Animal::IDENTIFICATION_TYPES)],
            'identification_number' => ['nullable', 'string', 'max:40'],
            'state'                 => ['nullable', Rule::in(Report::STATES)],
            'final_location '       => ['nullable', 'string', 'max:180'],
            'comment'               => ['nullable', 'string', 'max:1000'],
        ];
    }

    public function attributes()
    {
        return [
            'user_id' => __('messages.global.user'),
            'location_address' => __('messages.global.address'),
            'location_latitude' => __('messages.global.latitude'),
            'location_longitude' => __('messages.global.longitude'),
            'type' => __('messages.global.report_type'),
            'animal_species' => __('messages.global.animal_species'),
            'animal_condition' => __('messages.global.animal_condition'),
            'identification_type' => __('messages.global.identification_type'),
            'identification_number' => __('messages.global.identification_number'),
            'state' => __('messages.global.state'),
            'final_location' => __('messages.global.where_is_animal'),
            'comment' => __('messages.global.comment'),
        ];
    }

    // End of class
}
