<?php

namespace Modules\Admin\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

use Modules\Common\Entities\PremiumCity;

class CreatePremiumCityRequest extends FormRequest
{

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'city'     => ['required', 'string', 'max:30'],
            'zipcodes' => ['required', 'string', 'max:180'],
            'country'  => ['required', Rule::in(PremiumCity::COUNTRIES)],
        ];
    }

    public function attributes()
    {
        return [
            'city' => __('messages.global.city'),
            'zipcodes' => __('messages.global.zipcodes'),
            'country' => __('messages.global.country'),
        ];
    }

    // End of class
}
