<?php

namespace Modules\Admin\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

use Modules\Common\Entities\Place;

class CreatePlaceRequest extends FormRequest
{

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'name'               => ['required', 'string', 'max:60'],
            'type'               => ['required', Rule::in(Place::TYPES)],
            'phone'              => ['required', 'phone:AUTO', 'max:20'],
            'content'            => ['nullable', 'string', 'max:1000'],
            'zipcodes'           => ['nullable', 'string', 'max:180'],
            'country'            => ['nullable', 'string', 'max:30'],
            'location_address'   => ['required', 'string', 'max:180'],
            'location_latitude'  => ['nullable', 'numeric', 'min:-90',  'max:90'],
            'location_longitude' => ['nullable', 'numeric', 'min:-180', 'max:180'],
        ];
    }

    public function attributes()
    {
        return [
            'name'               => __('messages.global.name'),
            'type'               => __('messages.global.place_type'),
            'phone'              => __('messages.global.phone_number'),
            'content'            => __('messages.global.content'),
            'location_address'   => __('messages.global.address'),
            'location_latitude'  => __('messages.global.latitude'),
            'location_longitude' => __('messages.global.longitude'),
            'zipcodes'            => __('messages.global.zipcodes'),
            'country'            => __('messages.global.country'),
        ];
    }

    // End of class
}
