<?php

namespace Modules\Admin\Http\Controllers;

use Backpack\CRUD\app\Http\Controllers\CrudController;
use Backpack\CRUD\app\Library\CrudPanel\CrudPanelFacade as CRUD;
use Modules\Admin\Http\Requests\CreateTagRequest;
use Modules\Admin\Http\Requests\UpdateTagRequest;

class TagCrudController extends CrudController
{
    use \Backpack\CRUD\app\Http\Controllers\Operations\ListOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\ShowOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\CreateOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\UpdateOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\DeleteOperation;

    /***************************************************************************
     * Setup
     **************************************************************************/
    public function setup()
    {
        CRUD::setModel("Modules\Blog\Entities\Tag");
        CRUD::setRoute(config('backpack.base.route_prefix').'/tags');
        CRUD::setEntityNameStrings(__('messages.global.tag'), __('messages.global.tags'));
    }

    /***************************************************************************
     * List
     **************************************************************************/
    public function setupListOperation()
    {
        CRUD::addColumns($this->fields());
    }

    /***************************************************************************
     * Show
     **************************************************************************/
    public function setupShowOperation()
    {
        CRUD::addColumns($this->fields());
    }

    /***************************************************************************
     * Create
     **************************************************************************/
    public function setupCreateOperation()
    {
        CRUD::setValidation(CreateTagRequest::class);
        CRUD::addFields($this->fields());

    }

    /***************************************************************************
     * Update
     **************************************************************************/
    public function setupUpdateOperation()
    {
        CRUD::setValidation(UpdateTagRequest::class);
        CRUD::addFields($this->fields());
    }

    /***************************************************************************
     * Fields
     **************************************************************************/
    private function fields()
    {
        return [
            [
                'name' => 'name',
                'type' => 'text',
                'label' => __('messages.global.name'),
            ],
            [
                'name' => 'slug',
                'type' => 'text',
                'label' => __('messages.global.slug'),
            ],
        ];
    }

    // End of class
}
