<?php

namespace Modules\Admin\Http\Controllers;

use Backpack\CRUD\app\Http\Controllers\CrudController;
use Backpack\CRUD\app\Library\CrudPanel\CrudPanelFacade as CRUD;
use Modules\Admin\Http\Requests\CreatePremiumCityRequest;

use Modules\Common\Entities\PremiumCity;

class PremiumCityCrudController extends CrudController
{
    use \Backpack\CRUD\app\Http\Controllers\Operations\ListOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\ShowOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\CreateOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\UpdateOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\DeleteOperation;

    /***************************************************************************
     * Setup
     **************************************************************************/
    public function setup()
    {
        CRUD::setModel("Modules\Common\Entities\PremiumCity");
        CRUD::setRoute(config('backpack.base.route_prefix') . '/premium_cities');
        CRUD::setEntityNameStrings(__('messages.global.premium_city'), __('messages.global.premium_cities'));
    }

    /***************************************************************************
     * List
     **************************************************************************/
    public function setupListOperation()
    {
        CRUD::addColumns($this->fields());
        CRUD::removeColumns([
            'created_at', 'updated_at',
        ]);
    }

    /***************************************************************************
     * Show
     **************************************************************************/
    public function setupShowOperation()
    {
        CRUD::addColumns($this->fields());
    }

    /***************************************************************************
     * Create
     **************************************************************************/
    public function setupCreateOperation()
    {
        CRUD::setValidation(CreatePremiumCityRequest::class);
        CRUD::addFields($this->fields());
        CRUD::removeFields([
            'created_at', 'updated_at',
        ]);
    }

    /***************************************************************************
     * Update
     **************************************************************************/
    public function setupUpdateOperation()
    {
        CRUD::setValidation(CreatePremiumCityRequest::class);
        CRUD::addFields($this->fields());
        CRUD::removeFields([
            'created_at', 'updated_at',
        ]);
    }

    /***************************************************************************
     * Fields
     **************************************************************************/
    private function fields()
    {
        return [
            [
                'name' => 'city',
                'type' => 'text',
                'label' => __('messages.global.city'),
            ],
            [
                'name' => 'zipcodes',
                'type' => 'text',
                'label' => __('messages.global.zipcodes'),
            ],
            [
                'name' => 'country',
                'type' => 'select_from_array',
                'label' => __('messages.global.country'),
                'allows_null' => true,
                'options' => [
                    PremiumCity::COUNTRY_BELGIUM => __('messages.countries.' . PremiumCity::COUNTRY_BELGIUM),
                    PremiumCity::COUNTRY_FRANCE => __('messages.countries.' . PremiumCity::COUNTRY_FRANCE),
                ],
            ],
            [
                'name' => 'created_at',
                'type' => 'datetime',
                'label' => __('messages.global.created_at'),
            ],
            [
                'name' => 'updated_at',
                'type' => 'datetime',
                'label' => __('messages.global.updated_at'),
            ],
        ];
    }

    // End of class
}
