<?php

namespace Modules\Admin\Http\Controllers;

use Backpack\CRUD\app\Library\CrudPanel\CrudPanelFacade as CRUD;
use Modules\Common\Entities\User;


class OrganizationReportCrudController extends ReportCrudController
{

    /***************************************************************************
     * Setup
     **************************************************************************/
    public function setup()
    {
        parent::setup();

        $organizationId = \Route::current()->parameter('organization_id');
        $user = User::findOrFail($organizationId);

        $title =  __('messages.global.reports') . ' (' . $user->full_name . ')';

        CRUD::setRoute(config('backpack.base.route_prefix') . '/organizations/' . $organizationId . '/reports');
        CRUD::setTitle($title);
        CRUD::setHeading($title);
        CRUD::addClause('where', 'user_id', $organizationId);
    }

    /***************************************************************************
     * List
     **************************************************************************/
    public function setupListOperation()
    {
        parent::setupListOperation();

        CRUD::removeButton('export');
    }

    /***************************************************************************
     * Show
     **************************************************************************/
    public function show($id)
    {
        return parent::show(request()->id);
    }

    // End of class
}
