<?php

namespace Modules\Admin\Http\Controllers;

use Backpack\CRUD\app\Http\Controllers\CrudController;
use Backpack\CRUD\app\Library\CrudPanel\CrudPanelFacade as CRUD;
use Modules\Admin\Http\Requests\UpdateAbuseRequest;

use Modules\Common\Entities\Abuse;
use Modules\Common\Entities\Report;

class AbuseCrudController extends CrudController
{
    use \Backpack\CRUD\app\Http\Controllers\Operations\ListOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\ShowOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\UpdateOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\DeleteOperation;

    /***************************************************************************
     * Setup
     **************************************************************************/
    public function setup()
    {
        CRUD::setModel("Modules\Common\Entities\Abuse");
        CRUD::setRoute(config('backpack.base.route_prefix') . '/abuses');
        CRUD::setEntityNameStrings(__('messages.global.abuse'), __('messages.global.abuses'));
    }

    /***************************************************************************
     * List
     **************************************************************************/
    public function setupListOperation()
    {
        if (!$this->crud->getRequest()->has('order')) {
            CRUD::orderBy('state', 'desc');
            CRUD::orderBy('created_at', 'desc');
        }
        CRUD::addColumns($this->fields());
        CRUD::removeColumns([
            'user_id', 'state',
        ]);
        CRUD::addColumn([
            'name' => 'state',
            'type' => 'select_from_array',
            'label' => __('messages.global.state'),
            'allows_null' => true,
            'options' => [
                Abuse::STATE_WAITING => __('messages.abuse_state.' . Abuse::STATE_WAITING),
                Abuse::STATE_DONE => __('messages.abuse_state.' . Abuse::STATE_DONE),
            ],
            'wrapper' => [
                'element' => 'span',
                'class' => function ($crud, $column, $entry, $related_key) {
                    if ($related_key == Abuse::STATE_WAITING) {
                        return 'badge badge-warning';
                    } else if ($related_key == Abuse::STATE_DONE) {
                        return 'badge badge-success';
                    } else {
                        return 'badge badge-default';
                    }
                },
            ],
        ]);
    }

    /***************************************************************************
     * Show
     **************************************************************************/
    public function setupShowOperation()
    {
        CRUD::addColumns($this->fields());
    }

    /***************************************************************************
     * Update
     **************************************************************************/
    public function setupUpdateOperation()
    {
        CRUD::setValidation(UpdateAbuseRequest::class);
        CRUD::addFields($this->fields());
        CRUD::removeFields([
            'user_id', 'abusable', 'type', 'comment', 'created_at',
        ]);
    }

    /***************************************************************************
     * Fields
     **************************************************************************/
    private function fields()
    {
        return [
            [
                'name' => 'user_id',
                'type' => 'select',
                'label' => __('messages.global.user'),
                'attribute' => 'email',
                'entity' => 'user',
                'model' => 'Modules\Common\Entities\User',
            ],
            [
                'name' => 'abusable',
                'type' => 'relationship',
                'label' => __('messages.global.report'),
                'attribute' => 'id',
                'wrapper' => [
                    'element' => 'a',
                    'href' => function ($crud, $column, $entry, $related_key) {
                        if ($entry->abusable_type == Report::class) {
                            return backpack_url('reports/' . $entry->abusable_id . '/show');
                        }
                    },
                ],
            ],
            [
                'name' => 'type',
                'type' => 'select_from_array',
                'label' => __('messages.global.abuse_type'),
                'allows_null' => true,
                'options' => [
                    Abuse::TYPE_INAPPROPRIATE_CONTENT => __('messages.abuse_type.' . Abuse::TYPE_INAPPROPRIATE_CONTENT),
                    Abuse::TYPE_OTHER => __('messages.abuse_type.' . Abuse::TYPE_OTHER),
                ],
            ],
            [
                'name' => 'comment',
                'type' => 'textarea',
                'label' => __('messages.global.comment'),
            ],
            [
                'name' => 'state',
                'type' => 'select_from_array',
                'label' => __('messages.global.state'),
                'allows_null' => true,
                'options' => [
                    Abuse::STATE_WAITING => __('messages.abuse_state.' . Abuse::STATE_WAITING),
                    Abuse::STATE_DONE => __('messages.abuse_state.' . Abuse::STATE_DONE),
                ],
            ],
            [
                'name' => 'created_at',
                'type' => 'datetime',
                'label' => __('messages.global.created_at'),
            ],
        ];
    }

    // End of class
}
