@push('after_scripts')
  <script>
    // Autocompletion for address field
    var placeSearch, autocomplete;

    function initAutocomplete() {
      autocomplete = new google.maps.places.Autocomplete(
        document.getElementById('location_address'), {
          // types: ['(cities)']
        });

      autocomplete.setFields(['geometry']);
      autocomplete.addListener('place_changed', fillInAddress);
    }

    function fillInAddress() {
      var place = autocomplete.getPlace();

      document.getElementById('location_latitude').value = place.geometry.location.lat();
      document.getElementById('location_longitude').value = place.geometry.location.lng();

      for (var i = 0; i < place.address_components.length; i++) {
        var addressType = place.address_components[i].types[0];
        if (componentForm[addressType]) {
          var val = place.address_components[i][componentForm[addressType]];
          document.getElementById(addressType).value = val;
        }
      }
    }

    // Bias the autocomplete object to the user's geographical location,
    // as supplied by the browser's 'navigator.geolocation' object.
    function geolocate() {
      if (navigator.geolocation) {
        navigator.geolocation.getCurrentPosition(function(position) {
          var geolocation = {
            lat: position.coords.latitude,
            lng: position.coords.longitude
          };
          var circle = new google.maps.Circle({
            center: geolocation,
            radius: position.coords.accuracy
          });
          autocomplete.setBounds(circle.getBounds());
        });
      }
    }
  </script>

  <script
    src="https://maps.googleapis.com/maps/api/js?key={{ config('services.google_maps.api_key') }}&libraries=places&callback=initAutocomplete"
    async defer></script>
@endpush
