<!-- This file is used to store sidebar items, starting with Backpack\Base 0.9.0 -->

{{-- Dashboard --}}
<li class="nav-item"><a class="nav-link" href="{{ backpack_url('dashboard') }}"><i
      class="la la-home nav-icon"></i> {{ trans('backpack::base.dashboard') }}</a></li>

{{-- Blog --}}
<li class="nav-item nav-dropdown">
  <a class="nav-link nav-dropdown-toggle" href="#"><i class="nav-icon la la-newspaper-o"></i>
    {{ __('messages.global.blog') }}</a>
  <ul class="nav-dropdown-items">
    <li class="nav-item"><a class="nav-link" href="{{ backpack_url('posts') }}"><i
          class="nav-icon la la-newspaper-o"></i> {{ __('messages.global.posts') }}</a></li>
    <li class="nav-item"><a class="nav-link" href="{{ backpack_url('tags') }}"><i
          class="nav-icon la la-tag"></i> {{ __('messages.global.tags') }}</a></li>
  </ul>
</li>

{{-- Users --}}
<li class="nav-item"><a class="nav-link" href="{{ backpack_url('users') }}"><i
      class="nav-icon la la-user"></i> {{ __('messages.global.users') }}</a></li>

{{-- Organizations --}}
<li class="nav-item">
  <a class="nav-link" href="{{ backpack_url('organizations') }}">
    <i class="nav-icon la la-users"></i> {{ __('messages.global.organizations') }}
    @php
      $countOrganizationsNotVerified = \Modules\Common\Entities\User::isOrganization()
          ->isNotVerified()
          ->count();
    @endphp
    @if ($countOrganizationsNotVerified > 0)
      <span class="badge badge-warning">{{ $countOrganizationsNotVerified }}</span>
    @endif
  </a>
</li>

{{-- Reports --}}
<li class="nav-item"><a class="nav-link" href="{{ backpack_url('reports') }}"><i
      class="nav-icon la la-paw"></i> {{ __('messages.global.reports') }}</a></li>

{{-- Abuses --}}
<li class="nav-item">
  <a class="nav-link" href="{{ backpack_url('abuses') }}">
    <i class="nav-icon la la-flag"></i> {{ __('messages.global.abuses') }}
    @php
      $countWaitingAbuses = \Modules\Common\Entities\Abuse::waiting()->count();
    @endphp
    @if ($countWaitingAbuses > 0)
      <span class="badge badge-warning">{{ $countWaitingAbuses }}</span>
    @endif
  </a>
</li>

{{-- Places --}}
<li class="nav-item">
  <a class="nav-link" href="{{ backpack_url('places') }}">
    <i class="nav-icon la la-map-pin"></i> {{ __('messages.global.places') }}
  </a>
</li>

{{-- Premium cities --}}
<li class="nav-item">
  <a class="nav-link" href="{{ backpack_url('premium_cities') }}">
    <i class="nav-icon la la-money"></i> {{ __('messages.global.premium_cities') }}
  </a>
</li>
