<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Redirect;
use Modules\Common\Entities\Contracts\MustVerifyPhone;


class EnsurePhoneIsVerified
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if (
            !$request->user() ||
            ($request->user() instanceof MustVerifyPhone &&
                !$request->user()->hasVerifiedPhone())
        ) {
            return $request->expectsJson()
                ? response(['message' => __('auth.phone_not_verified'), 'error' => 'phone_not_verified'], 403)
                : Redirect::route('verification_phone.notice');
        }

        return $next($request);
    }

    // End of class
}
