<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Modules\Common\Entities\Report;

class ReportsExport implements FromCollection, WithMapping, WithHeadings
{
    public function collection()
    {
        return Report::withTrashed()->with('user')->get();
    }

    public function map($report): array
    {
        return [
            $report->id,
            $report->type,
            $report->animal_species,
            $report->animal_condition,
            $report->identification_type,
            $report->identification_number,
            $report->final_location,
            $report->comment,
            $report->location_address,
            $report->location_zipcode,
            $report->location_country,
            $report->location_latitude,
            $report->location_longitude,
            $report->state,
            $report->deletion_reason,
            $report->deletion_reason_comment,
            $report->created_at,
            $report->updated_at,
            $report->expires_at,
            $report->deleted_at,
            $report->user->email,
        ];
    }

    public function headings(): array
    {
        return [
            '#',
            'Type',
            'Species',
            'Condition',
            'Ident. type',
            'Ident. number',
            'Final location',
            'Comment',
            'Address',
            'Zipcode',
            'Country',
            'Latitute',
            'Longitude',
            'State',
            'Deletion reason',
            'Deletion reason (comment)',
            'Created at',
            'Updated at',
            'Expires at',
            'Deleted at',
            'User',
        ];
    }

    // End of class
}
