<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

use Modules\Common\Entities\Report;
use Modules\Common\Notifications\NotifyUserOfAlmostExpiredReport;
use Modules\Common\Notifications\NotifyUserOfExpiredReport;


class NotifyExpirationOfReports extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'reports:notify-expiration';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Notify expiration of reports';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $this->notifyAlmostExpiredReports(); 
        $this->notifyExpiredReports(); 
    }
    
    private function notifyAlmostExpiredReports() 
    {
        Report::remainingHours(72)->chunk(25, function($reports) {
            foreach($reports as $report) {
                //$this->info('Report #' . $report->id . ' is almost expired');
                $report->user->notify(new NotifyUserOfAlmostExpiredReport($report));
            }
        });        
    }
    
    private function notifyExpiredReports() 
    {
        Report::remainingHours(0)->chunk(25, function($reports) {
            foreach($reports as $report) {
                //$this->info('Report #' . $report->id . ' is expired');
                $report->user->notify(new NotifyUserOfExpiredReport($report));
            }
        });        
    }
    
    // End of class
}
