<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Modules\Common\Entities\User;
use Modules\Common\Notifications\NotifyUserOfFullyDeletionAccount;


class DeleteUsers extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'users:delete';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Delete users';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $this->deleteUsers();
    }

    private function deleteUsers()
    {
        User::onlyTrashed()->deletedSinceInDays(15)->chunk(25, function ($users) {
            foreach ($users as $user) {
                $user->notify(new NotifyUserOfFullyDeletionAccount());
                $user->forceDeleteWithMembers();
            }
        });
    }

    // End of class
}
