<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Storage;


class DeleteTemporaryImages extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'temporary-images:delete';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Delete temporary images';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $this->deleteTemporaryImages();
    }

    private function deleteTemporaryImages()
    {
        collect(Storage::disk('tmp')->listContents())
            ->each(function ($file) {
                if ($file['type'] == 'file' && $file['timestamp'] < now()->subHours(24)->getTimestamp()) {
                    Storage::disk('tmp')->delete($file['path']);
                }
            });
    }

    // End of class
}
