<?php

namespace Modules\User\Tests\Browser;

use Illuminate\Foundation\Testing\DatabaseMigrations;
use Laravel\Dusk\Browser;
use Tests\DuskTestCase;

use Modules\Common\Entities\User;

class RegisterTest extends DuskTestCase
{
    use DatabaseMigrations;
            
    /***************************************************************************
     * Tests
     **************************************************************************/   
    public function testRegisterWithExistingEmail()
    {
        $user = factory(User::class)->create([
            'email' => 'test@example.org',
        ]);
        
        $this->browse(function (Browser $browser) use ($user) {
            $browser->driver->manage()->deleteAllCookies();
            $browser->visit('/user/auth/register')
                    ->type('first_name', 'John')
                    ->type('last_name', 'Doe')
                    ->type('phone', '0412345678')
                    ->type('email', $user->email)
                    ->type('password', 'password')
                    ->click('label[class="form-check-label"]')
                    ->press('Inscription')
                    ->assertPathIs('/user/auth/register')
                    ->assertSee('Le champ e-mail est déjà utilisé');
        });
    }
    
    public function testRegisterSuccessfully()
    {
        $this->browse(function (Browser $browser) {
            $browser->driver->manage()->deleteAllCookies();
            $browser->visit('/user/auth/register')
                    ->type('first_name', 'John')
                    ->type('last_name', 'Doe')
                    ->type('phone', '0412345678')
                    ->type('email', 'text@example.org')
                    ->type('password', 'password')
                    ->click('label[class="form-check-label"]')
                    ->press('Inscription')
                    ->assertPathIs('/user/auth/email/verify');
        });
    }  
    
    
    // End of class
}
