<?php

namespace Modules\User\Tests\Browser;

use Illuminate\Foundation\Testing\DatabaseMigrations;
use Laravel\Dusk\Browser;
use Tests\DuskTestCase;

use Modules\Common\Entities\User;

class LoginTest extends DuskTestCase
{
    use DatabaseMigrations;

    /***************************************************************************
     * Tests
     **************************************************************************/
    public function testLoginWithBadCredentials()
    {
        $user = factory(User::class)->create([
            'email' => 'test@example.org',
        ]);

        $this->browse(function (Browser $browser) use ($user) {
            $browser->driver->manage()->deleteAllCookies();
            $browser->visit('/user/auth/login')
                    ->type('email', $user->email)
                    ->type('password', 'wrong_password')
                    ->press('Connexion')
                    ->assertPathIs('/user/auth/login');
        });
    }

    public function testLoginWithNotVerified()
    {
        $user = factory(User::class)->create([
            'email' => 'test@example.org',
        ]);

        $this->browse(function (Browser $browser) use ($user) {
            $browser->driver->manage()->deleteAllCookies();
            $browser->visit('/user/auth/login')
                    ->type('email', $user->email)
                    ->type('password', 'password')
                    ->press('Connexion')
                    ->assertPathIs('/user/auth/email/verify');
        });
    }

    public function testLoginSuccessfully()
    {
        $user = factory(User::class)->create([
            'email' => 'test@example.org',
            'email_verified_at' => '2020-01-01 00:00:00',
        ]);

        $this->browse(function (Browser $browser) use ($user) {
            $browser->driver->manage()->deleteAllCookies();
            $browser->visit('/user/auth/login')
                    ->type('email', $user->email)
                    ->type('password', 'password')
                    ->press('Connexion')
                    ->assertPathIs('/user/profile');
        });
    }

    // End of class
}
