<?php

$languagesRegExp = implode('|', array_keys(config('app.languages')));
Route::pattern('locale', $languagesRegExp);

Route::group(['middleware' => 'locale', 'prefix' => '/{locale}'], function () {
    Route::prefix('user')->group(function () {

        // Authentication
        Route::group(['prefix' => 'auth', 'namespace' => 'Auth'], function () {
            Route::get('/register', 'RegisterController@showRegisterForm')->name('user.auth.showRegisterForm');
            Route::post('/register', 'RegisterController@register')->name('user.auth.register');
            Route::get('/login', 'LoginController@showLoginForm')->name('user.auth.showLoginForm');
            Route::post('/login', 'LoginController@login')->name('user.auth.login');
            Route::get('/logout', 'LoginController@logout')->name('user.auth.logout');

            // Verification Email
            Route::get('email/verify', 'VerificationController@show')->name('verification.notice');
            Route::get('email/verify/{id}/{hash}', 'VerificationController@verify')->name('verification.verify');
            Route::post('email/resend', 'VerificationController@resend')->name('verification.resend');

            // Forgot Password
            Route::get('password/reset', 'ForgotPasswordController@showLinkRequestForm')->name('password.request');
            Route::post('password/email', 'ForgotPasswordController@sendResetLinkEmail')->name('password.email');
            Route::get('password/reset/{token}', 'ResetPasswordController@showResetForm')->name('password.reset');
            Route::post('password/reset', 'ResetPasswordController@reset')->name('password.update');

            // Authenticated routes
            Route::group(['middleware' => ['auth:user', 'active']], function () {

                // Verification Phone
                //Route::get('phone/verify', 'VerificationPhoneController@show')->name('verification_phone.notice');
                //Route::post('phone/verify', 'VerificationPhoneController@verify')->name('verification_phone.verify');
                //Route::post('phone/resend', 'VerificationPhoneController@resend')->name('verification_phone.resend');
            });
        });

        // Authenticated routes
        Route::group(['middleware' => ['auth:user', 'email_verified', 'active']], function () {

            // Profile
            Route::get('/profile', 'ProfileController@index')->name('user.profile.index');

            // Only for individual or organization accounts
            Route::group(['middleware' => ['account:individual|organization']], function () {

                // Profile
                Route::post('/profile', 'ProfileController@update')->name('user.profile.update');

                // Delete Account
                Route::get('/account/delete-account/request', 'DeleteAccountController@showLinkRequestForm')->name('delete-account.request');
                Route::post('/account/delete-account/email', 'DeleteAccountController@sendDeleteLinkEmail')->name('delete-account.email');
                Route::get('/account/delete-account/delete/{id}/{hash}', 'DeleteAccountController@delete')
                    ->withoutMiddleware(['auth:user', 'account:individual|organization', 'email_verified', 'active'])
                    ->name('delete-account.delete');
            });

            // Media
            Route::post('/media', 'MediaController@store')->name('user.media.store');

            // Reports
            Route::get('/reports', 'ReportController@index')->name('user.reports.index');
            Route::get('/reports/{report_id}/show', 'ReportController@show')->name('user.reports.show');
            Route::get('/reports/{report}/edit', 'ReportController@edit')->name('user.reports.edit');
            Route::post('/reports/{report}/edit', 'ReportController@update')->name('user.reports.update');
            Route::get('/reports/{report}/remove', 'ReportController@remove')->name('user.reports.remove');
            Route::post('/reports/{report}/delete', 'ReportController@delete')->name('user.reports.delete');
            Route::get('/reports/{report}/extend_expiration', 'ReportController@extendExpiration')->name('user.reports.extendExpiration');
            Route::get('/reports/{report}/suspend', 'ReportController@suspend')->name('user.reports.suspend');
            Route::get('/reports/{report}/unsuspend', 'ReportController@unsuspend')->name('user.reports.unsuspend');

            // Only for individual and organization accounts
            Route::group(['middleware' => ['account:individual|organization']], function () {

                // Reports
                Route::get('/reports/create', 'ReportController@create')->name('user.reports.create');
                Route::post('/reports/create', 'ReportController@store')->name('user.reports.store');

                // Only for premium users
                Route::group(['middleware' => ['premium']], function () {

                    // Registered Animals
                    Route::get('/registered_animals', 'RegisteredAnimalController@index')->name('user.registered_animals.index');
                    Route::get('/registered_animals/{registered_animal}/show', 'RegisteredAnimalController@show')->name('user.registered_animals.show');
                    Route::get('/registered_animals/{registered_animal}/edit', 'RegisteredAnimalController@edit')->name('user.registered_animals.edit');
                    Route::post('/registered_animals/{registered_animal}/edit', 'RegisteredAnimalController@update')->name('user.registered_animals.update');
                    Route::get('/registered_animals/{registered_animal}/delete', 'RegisteredAnimalController@delete')->name('user.registered_animals.delete');
                    Route::get('/registered_animals/create', 'RegisteredAnimalController@create')->name('user.registered_animals.create');
                    Route::post('/registered_animals/create', 'RegisteredAnimalController@store')->name('user.registered_animals.store');
                });
            });

            // Only for organization accounts
            Route::group(['middleware' => ['account:organization']], function () {

                // Only for verified organizations
                Route::group(['middleware' => ['organization_verified']], function () {

                    // Reports
                    Route::get('/found_reports/create', 'FoundReportController@create')->name('user.found_reports.create');
                    Route::post('/found_reports/create', 'FoundReportController@store')->name('user.found_reports.store');

                    // Members
                    Route::get('/members', 'MemberController@index')->name('user.members.index');
                    Route::get('/members/{member}/show', 'MemberController@show')->name('user.members.show');
                    Route::get('/members/{member}/edit', 'MemberController@edit')->name('user.members.edit');
                    Route::post('/members/{member}/edit', 'MemberController@update')->name('user.members.update');
                    Route::get('/members/{member}/delete', 'MemberController@delete')->name('user.members.delete');
                    Route::get('/members/create', 'MemberController@create')->name('user.members.create');
                    Route::post('/members/create', 'MemberController@store')->name('user.members.store');
                });
            });
        });
    });
});
