@extends('user::_layouts.authenticated.layout')

@section('title', __('messages.global.report_detail'))

@section('content')

  <div class="row">
    <div class="col-md-12">
      <div class="card">
        <div class="card-header">
          <h4 class="card-title">
            {{ $report->trashed()? __('messages.global.deleted_report_detail'): __('messages.global.report_detail') }}
          </h4>
        </div>
        <div class="card-body">
          <div class="table-responsive">
            <table class="table">
              <tr>
                <th>{{ __('messages.global.state') }}</th>
                <td class="{{ $report->isSuspended() ? 'text-warning' : 'text-success' }}">
                  {{ $report->stateFormatted }}</td>
              </tr>
              <tr>
                <th>#</th>
                <td>{{ $report->id }}</td>
              </tr>
              <tr>
                <th>{{ __('messages.global.created_at') }}</th>
                <td>{{ $report->createdAtDateTimeFormatted }}</td>
              </tr>
              <tr>
                <th>{{ __('messages.global.expires_at') }}</th>
                <td>
                  @if ($report->hasExpired())
                    <span class="text-danger">{{ __('messages.global.expired') }}</span>
                  @else
                    {{ $report->expiresAtDateTimeFormatted }}
                  @endif
                </td>
              </tr>
              <tr>
                <th>{{ __('messages.global.report_type') }}</th>
                <td class="{{ $report->isFound() ? 'text-success' : 'text-danger' }}">
                  {{ $report->typeFormatted }}</td>
              </tr>
              <tr>
                <th>{{ __('messages.global.pictures') }}</th>
                <td>
                  @foreach ($report->getMedia() as $media)
                    <a href="{{ $media->getFullUrl('medium') }}" target="_blank">
                      <img src="{{ $media->getFullUrl('thumb') }}" alt=""
                        style="width: 40px; height: 40px; object-fit: cover;">
                    </a>
                  @endforeach
                </td>
              </tr>
              <tr>
                <th>{{ __('messages.global.address') }}</th>
                <td>{{ $report->location_address }}</td>
              </tr>
              <tr>
                <th>{{ __('messages.global.latitude') }}</th>
                <td>{{ $report->location_latitude }}</td>
              </tr>
              <tr>
                <th>{{ __('messages.global.longitude') }}</th>
                <td>{{ $report->location_longitude }}</td>
              </tr>
              <tr>
                <th>{{ __('messages.global.animal_species') }}</th>
                <td>{{ $report->animalSpeciesFormatted }}</td>
              </tr>
              @if ($report->isFound())
                <tr>
                  <th>{{ __('messages.global.animal_condition') }}</th>
                  <td>{{ $report->animalConditionFormatted }}</td>
                </tr>
              @endif
              <tr>
                <th>{{ __('messages.global.identification_type') }}</th>
                <td>{{ $report->identificationtypeFormatted }}</td>
              </tr>
              <tr>
                <th>{{ __('messages.global.identification_number') }}</th>
                <td>{{ $report->identification_number }}</td>
              </tr>
              @if ($report->isFound())
                <tr>
                  <th>{{ __('messages.global.where_is_animal') }}</th>
                  <td>{{ $report->final_location }}</td>
                </tr>
              @endif
              <tr>
                <th>{{ __('messages.global.comment') }}</th>
                <td>{{ $report->comment }}</td>
              </tr>
              @if ($user->isOrganization)
                <tr>
                  <th>{{ __('messages.global.author') }}</th>
                  <td>{{ $report->user->fullName }}</td>
                </tr>
              @endif
              @if ($report->trashed())
                <tr>
                  <th>{{ __('messages.global.deletion_reason') }}</th>
                  <td>{{ $report->deletion_reason_formatted }}</td>
                </tr>
                <tr>
                  <th>{{ __('messages.global.deletion_reason_comment') }}</th>
                  <td>{{ $report->deletion_reason_comment }}</td>
                </tr>
              @else
                <tr>
                  <th>{{ __('messages.global.actions') }}</th>
                  <td>
                    <a class="btn btn-round btn-default"
                      href="{{ route('user.reports.extendExpiration', $report) }}">{{ __('messages.global.extend_expiration') }}</a>
                    @if ($report->isWaiting())
                      <a class="btn btn-round btn-default"
                        href="{{ route('user.reports.suspend', $report) }}">{{ __('messages.global.suspend') }}</a>
                    @elseif ($report->isSuspended())
                      <a class="btn btn-round btn-default"
                        href="{{ route('user.reports.unsuspend', $report) }}">{{ __('messages.global.unsuspend') }}</a>
                    @endif
                    <a class="btn btn-round btn-warning" href="{{ route('user.reports.edit', $report) }}"
                      title="{{ __('messages.global.edit') }}">
                      <i class="fa fa-edit"></i></a>
                    <a class="btn btn-round btn-danger" href="{{ route('user.reports.remove', $report) }}"
                      title="{{ __('messages.global.delete') }}">
                      <i class="fa fa-trash"></i></a>
                  </td>
                </tr>
              @endif
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>

  {{-- Confirm Delete Dialog --}}
  @include(
      'user::_layouts.authenticated._partials.confirm_delete_dialog'
  )

@endsection
