@extends('user::_layouts.authenticated.layout')

@section('title', __('messages.global.delete_report'))

@section('content')
  <div class="row">

    <div class="col-lg-4">
    </div>

    <div class="col-lg-8 order-first">

      <div class="card card-user">
        <div class="card-header">
          <h5 class="card-title">{{ __('messages.global.delete_report') }}</h5>
        </div>
        <div class="card-body">
          <form enctype="multipart/form-data" method="post" action="{{ route('user.reports.delete', $report) }}">
            {{ csrf_field() }}


            <div class="row">
              <div class="col-md-6">
                <div class="form-group">
                  <label for="deletion_reason">{{ __('messages.global.deletion_reason') }}</label>
                  <select id="deletion_reason" name="deletion_reason" class="custom-select"
                    placeholder="{{ __('messages.global.deletion_reason') }}">
                    <option value="">-</option>
                    @foreach ($deletionReasons as $reason)
                      <option value="{{ $reason }}" {{ old('deletion_reason') == $reason ? 'selected' : '' }}>
                        {{ __('messages.deletion_reason.' . $reason) }}</option>
                    @endforeach
                  </select>
                  @if ($errors->has('deletion_reason'))
                    <span class="small text-danger">{{ $errors->first('deletion_reason') }}</span>
                  @endif
                </div>
              </div>
            </div>

            <div class="row">
              <div class="col-md-12">
                <div class="form-group">
                  <label for="deletion_reason_comment">{{ __('messages.global.comment') }}</label>
                  <textarea id="deletion_reason_comment" name="deletion_reason_comment" class="form-control" rows="3"
                    placeholder="{{ __('messages.global.comment') }}"
                    value="{{ old('deletion_reason_comment') }}"></textarea>
                  <div id="the-count" class="text-right small text-muted">
                    <span id="current">0</span>
                    <span id="maximum">/ 1000</span>
                  </div>
                  @if ($errors->has('deletion_reason_comment'))
                    <span class="small text-danger">{{ $errors->first('deletion_reason_comment') }}</span>
                  @endif
                </div>
              </div>
            </div>

            <div class="row">
              <div class="update ml-auto mr-auto">
                <button type="submit" name="delete-report"
                  class="btn btn-primary btn-round">{{ __('messages.global.delete') }}</button>
              </div>
            </div>
          </form>
        </div>
      </div>
    </div>

  </div>

  {{-- Confirm Delete Dialog --}}
  @include('user::_layouts.authenticated._partials.confirm_delete_dialog')

@endsection

@section('js')
  <script>
    // Counter for comment textarea
    $('textarea#deletion_reason_comment').keyup(function() {

      var characterCount = $(this).val().length,
        current = $('#current'),
        maximum = $('#maximum'),
        theCount = $('#the-count');

      if (characterCount > 1000) {
        $(this).val($(this).val().substring(0, 1000));
        characterCount = $(this).val().length;
        theCount.removeClass('text-muted');
        theCount.addClass('text-danger');
        theCount.addClass('text-bold');
      } else {
        theCount.addClass('text-muted');
        theCount.removeClass('text-danger');
        theCount.removeClass('text-bold');
      }

      current.text(characterCount);
    });
  </script>
@endsection
