@extends('user::_layouts.authenticated.layout')

@section('title', $showDeleted ? __('messages.global.my_deleted_reports') :
  __('messages.global.my_reports'))

@section('content')

  <div class="row">
    <div class="col-md-12">
      <div class="card">
        <div class="card-header">
          <h4 class="card-title">
            {{ $showDeleted ? __('messages.global.my_deleted_reports') : __('messages.global.my_reports') }}
          </h4>
        </div>
        <div class="card-body">
          <div>
            @if ($user->isIndividual)
              <a class="btn btn-round btn-success" href="{{ route('user.reports.create') }}">
                {{ __('messages.global.i_lost_my_animal') }}
              </a>
            @endif
            @if ($showDeleted)
              <a class="btn btn-round btn-default" href="{{ route('user.reports.index') }}">
                {{ __('messages.global.show_my_current_reports') }}
              </a>
            @else
              <a class="btn btn-round btn-default" href="{{ route('user.reports.index', 'showDeleted') }}">
                {{ __('messages.global.show_my_deleted_reports') }}
              </a>
            @endif
          </div>
          <div class="table-responsive">
            <table class="table">
              <thead class="text-primary">
                <th>
                  {{ __('messages.global.picture') }}
                </th>
                <th>
                  @sortablelink('created_at', __('messages.global.date'))
                </th>
                <th>
                  @sortablelink('animal_species', __('messages.global.species'))
                </th>
                <th>
                  @sortablelink('type', __('messages.global.report_type'))
                </th>
                <th>
                  @sortablelink('expires_at', __('messages.global.expires_at'))
                </th>
                @if ($user->isOrganization)
                  <th>
                    @sortablelink('user_id', __('messages.global.author'))
                  </th>
                @endif
                @if (!$showDeleted)
                  <th>
                    @sortablelink('state', __('messages.global.state'))
                  </th>
                @endif
                <th class="text-right">
                  {{ __('messages.global.actions') }}
                </th>
              </thead>
              <tbody>
                @forelse($reports as $report)
                  <tr>
                    <td>
                      <a href="{{ $report->firstImage }}" target="_blank">
                        <img class="img-fluid" src="{{ $report->thumbnail }}" alt=""
                          style="width: 40px; height: 40px; object-fit: cover;">
                      </a>
                    </td>
                    <td>
                      {{ $report->createdAtDateTimeFormatted }}
                    </td>
                    <td>
                      {{ $report->animalSpeciesFormatted }}
                    </td>
                    <td class="{{ $report->isFound() ? 'text-success' : 'text-danger' }}">
                      {{ $report->typeFormatted }}
                    </td>
                    <td>
                      @if ($report->hasExpired())
                        <span class="text-danger">{{ __('messages.global.expired') }}</span>
                      @else
                        {{ $report->expiresAtDateTimeFormatted }}
                      @endif
                    </td>
                    @if ($user->isOrganization)
                      <td>
                        {{ $report->user->full_name }}
                      </td>
                    @endif
                    @if (!$showDeleted)
                      <td class="{{ $report->isSuspended() ? 'text-warning' : 'text-success' }}">
                        {{ $report->stateFormatted }}
                      </td>
                    @endif
                    @if ($showDeleted)
                      <td class="text-right">
                        <a class="btn btn-round btn-success" href="{{ route('user.reports.show', $report) }}"
                          title="{{ __('messages.global.show') }}">
                          <i class="fa fa-eye"></i>
                        </a>
                      </td>
                    @else
                      <td class="text-right">
                        <a class="btn btn-round btn-default"
                          href="{{ route('user.reports.extendExpiration', $report) }}">{{ __('messages.global.extend_expiration') }}</a>
                        @if ($report->isWaiting())
                          <a class="btn btn-round btn-default"
                            href="{{ route('user.reports.suspend', $report) }}">{{ __('messages.global.suspend') }}</a>
                        @elseif ($report->isSuspended())
                          <a class="btn btn-round btn-default"
                            href="{{ route('user.reports.unsuspend', $report) }}">{{ __('messages.global.unsuspend') }}</a>
                        @endif
                        <a class="btn btn-round btn-success" href="{{ route('user.reports.show', $report) }}"
                          title="{{ __('messages.global.show') }}">
                          <i class="fa fa-eye"></i>
                        </a>
                        <a class="btn btn-round btn-warning" href="{{ route('user.reports.edit', $report) }}"
                          title="{{ __('messages.global.edit') }}">
                          <i class="fa fa-edit"></i></a>
                        <a class="btn btn-round btn-danger" href="{{ route('user.reports.remove', $report) }}"
                          title="{{ __('messages.global.delete') }}">
                          <i class="fa fa-trash"></i></a>
                      </td>
                    @endif
                  </tr>
                @empty
                  <tr>
                    <td colspan="5">
                      {{ __('messages.global.no_reports') }}
                    </td>
                  </tr>
                @endforelse
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>

@endsection
