@extends('user::_layouts.authenticated.layout')

@section('title', __('messages.global.edit_report'))

@section('content')
  <div class="row">

    <div class="col-lg-4">
    </div>

    <div class="col-lg-8 order-first">

      <div class="card card-user">
        <div class="card-header">
          <h5 class="card-title">{{ __('messages.global.edit_report') }}</h5>
        </div>
        <div class="card-body">
          <form method="post" action="{{ route('user.reports.update', $report) }}">
            {{ csrf_field() }}

            <div class="row">
              <div class="col-md-6">
                <div class="form-group">
                  <label for="animal_species">{{ __('messages.global.animal_species') }}</label>
                  <select id="animal_species" name="animal_species" class="custom-select"
                    placeholder="{{ __('messages.global.animal_species') }}">
                    <option>-</option>

                    {{-- Pet --}}
                    <optgroup label="{{ __('messages.animal_species_categories.pet') }}">

                      {{-- Pet Dog --}}
                    <optgroup label="{{ __('messages.animal_species_categories.pet_dog') }}">
                      @foreach ($animalSpecies as $species)
                        @if (Str::startsWith($species, 'pet_dog'))
                          <option value="{{ $species }}"
                            {{ old('animal_species', $report->animal_species) == $species ? 'selected' : '' }}>
                            {{ __('messages.animal_species.' . $species) }}</option>
                        @endif
                      @endforeach
                    </optgroup>

                    {{-- Pet Cat --}}
                    <optgroup label="{{ __('messages.animal_species_categories.pet_cat') }}">
                      @foreach ($animalSpecies as $species)
                        @if (Str::startsWith($species, 'pet_cat'))
                          <option value="{{ $species }}"
                            {{ old('animal_species', $report->animal_species) == $species ? 'selected' : '' }}>
                            {{ __('messages.animal_species.' . $species) }}</option>
                        @endif
                      @endforeach
                    </optgroup>

                    {{-- Pet Other --}}
                    <optgroup label="{{ __('messages.animal_species_categories.pet_other') }}">
                      @foreach ($animalSpecies as $species)
                        @if (Str::startsWith($species, 'pet') && !Str::startsWith($species, 'pet_dog') && !Str::startsWith($species, 'pet_cat'))
                          <option value="{{ $species }}"
                            {{ old('animal_species', $report->animal_species) == $species ? 'selected' : '' }}>
                            {{ __('messages.animal_species.' . $species) }}</option>
                        @endif
                      @endforeach
                    </optgroup>
                    </optgroup>

                    {{-- Livestock --}}
                    <optgroup label="{{ __('messages.animal_species_categories.livestock') }}">
                      @foreach ($animalSpecies as $species)
                        @if (Str::startsWith($species, 'livestock'))
                          <option value="{{ $species }}"
                            {{ old('animal_species', $report->animal_species) == $species ? 'selected' : '' }}>
                            {{ __('messages.animal_species.' . $species) }}</option>
                        @endif
                      @endforeach
                    </optgroup>

                    {{-- Circus --}}
                    <optgroup label="{{ __('messages.animal_species_categories.circus') }}">
                      @foreach ($animalSpecies as $species)
                        @if (Str::startsWith($species, 'circus'))
                          <option value="{{ $species }}"
                            {{ old('animal_species', $report->animal_species) == $species ? 'selected' : '' }}>
                            {{ __('messages.animal_species.' . $species) }}</option>
                        @endif
                      @endforeach
                    </optgroup>

                    {{-- Wild --}}
                    <optgroup label="{{ __('messages.animal_species_categories.wild') }}">
                      @foreach ($animalSpecies as $species)
                        @if (Str::startsWith($species, 'wild') && !Str::startsWith($species, 'wild_aquatic'))
                          <option value="{{ $species }}"
                            {{ old('animal_species', $report->animal_species) == $species ? 'selected' : '' }}>
                            {{ __('messages.animal_species.' . $species) }}</option>
                        @endif
                      @endforeach
                    </optgroup>

                    {{-- Wild Aquatic --}}
                    <optgroup label="{{ __('messages.animal_species_categories.wild_aquatic') }}">
                      @foreach ($animalSpecies as $species)
                        @if (Str::startsWith($species, 'wild_aquatic'))
                          <option value="{{ $species }}"
                            {{ old('animal_species', $report->animal_species) == $species ? 'selected' : '' }}>
                            {{ __('messages.animal_species.' . $species) }}</option>
                        @endif
                      @endforeach
                    </optgroup>

                  </select>
                  @if ($errors->has('animal_species'))
                    <span class="small text-danger">{{ $errors->first('animal_species') }}</span>
                  @endif
                </div>
              </div>
              @if ($report->isFound())
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="animal_condition">{{ __('messages.global.animal_condition') }}</label>
                    <select id="animal_condition" name="animal_condition" class="custom-select"
                      placeholder="{{ __('messages.global.animal_condition') }}">
                      <option>-</option>
                      @foreach ($animalConditions as $condition)
                        <option value="{{ $condition }}"
                          {{ old('animal_condition', $report->animal_condition) == $condition ? 'selected' : '' }}>
                          {{ __('messages.animal_condition.' . $condition) }}</option>
                      @endforeach
                    </select>
                    @if ($errors->has('animal_condition'))
                      <span class="small text-danger">{{ $errors->first('animal_condition') }}</span>
                    @endif
                  </div>
                </div>
              @endif
            </div>

            <div class="row">
              <div class="col-md-6">
                <div class="form-group">
                  <label for="identification_type">{{ __('messages.global.identification_type') }}</label>
                  <select id="identification_type" name="identification_type" class="custom-select"
                    placeholder="{{ __('messages.global.identification_type') }}">
                    <option value="">-</option>
                    @foreach ($identificationTypes as $identificationType)
                      <option value="{{ $identificationType }}"
                        {{ old('identification_type', $report->identification_type) == $identificationType ? 'selected' : '' }}>
                        {{ __('messages.identification_type.' . $identificationType) }}</option>
                    @endforeach
                  </select>
                  @if ($errors->has('identification_type'))
                    <span class="small text-danger">{{ $errors->first('identification_type') }}</span>
                  @endif
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label for="identification_number">{{ __('messages.global.identification_number') }}</label>
                  <input type="text" id="identification_number" name="identification_number" class="form-control"
                    placeholder="{{ __('messages.global.identification_number') }}"
                    value="{{ old('identification_number', $report->identification_number) }}">
                  @if ($errors->has('identification_number'))
                    <span class="small text-danger">{{ $errors->first('identification_number') }}</span>
                  @endif
                </div>
              </div>
            </div>

            @if ($report->isFound())
              <div class="row">
                <div class="col-md-12">
                  <div class="form-group">
                    <label for="final_location">{{ __('messages.global.where_is_animal') }}</label>
                    <input type="text" id="final_location" name="final_location" class="form-control"
                      placeholder="{{ __('messages.global.where_is_animal') }}"
                      value="{{ old('final_location', $report->final_location) }}">
                    @if ($errors->has('final_location'))
                      <span class="small text-danger">{{ $errors->first('final_location') }}</span>
                    @endif
                  </div>
                </div>
              </div>
            @endif

            <div class="row">
              <div class="col-md-12">
                <div class="form-group">
                  <label for="comment">{{ __('messages.global.comment') }}</label>
                  <textarea id="comment" name="comment" class="form-control" rows="3"
                    placeholder="{{ __('messages.global.comment') }}">{{ old('comment', $report->comment) }}</textarea>
                  <div id="the-count" class="text-right small text-muted">
                    <span id="current">0</span>
                    <span id="maximum">/ 1000</span>
                  </div>
                  @if ($errors->has('comment'))
                    <span class="small text-danger">{{ $errors->first('comment') }}</span>
                  @endif
                </div>
              </div>
            </div>

            <div class="row">
              <div class="update ml-auto mr-auto">
                <button type="submit" name="edit-report"
                  class="btn btn-primary btn-round">{{ __('messages.global.update') }}</button>
              </div>
            </div>
          </form>
        </div>
      </div>
    </div>

  </div>
@endsection

@section('js')
  <script>
    // Counter for comment textarea
    $('textarea#comment').keyup(function() {

      var characterCount = $(this).val().length,
        current = $('#current'),
        maximum = $('#maximum'),
        theCount = $('#the-count');

      if (characterCount > 1000) {
        $(this).val($(this).val().substring(0, 1000));
        characterCount = $(this).val().length;
        theCount.removeClass('text-muted');
        theCount.addClass('text-danger');
        theCount.addClass('text-bold');
      } else {
        theCount.addClass('text-muted');
        theCount.removeClass('text-danger');
        theCount.removeClass('text-bold');
      }

      current.text(characterCount);
    });
  </script>
@endsection
