@extends('user::_layouts.authenticated.layout')

@section('title', __('messages.global.my_animals'))

@section('content')

  <div class="row">
    <div class="col-md-12">
      <div class="card">
        <div class="card-header">
          <h4 class="card-title">{{ __('messages.global.my_animals') }}</h4>
        </div>
        <div class="card-body">
          <div>
            <a class="btn btn-round btn-success"
              href="{{ route('user.registered_animals.create') }}">{{ __('messages.global.register_my_animal') }}</a>
          </div>
          <div class="table-responsive">
            <table class="table">
              <thead class="text-primary">
                <th>
                  {{ __('messages.global.picture') }}
                </th>
                <th>
                  {{ __('messages.global.animal_name') }}
                </th>
                <th>
                  {{ __('messages.global.species') }}
                </th>
                <th class="text-right">
                  {{ __('messages.global.actions') }}
                </th>
              </thead>
              <tbody>
                @forelse($registeredAnimals as $registered_animal)
                  <tr>
                    <td>
                      <a href="{{ $registered_animal->firstImage }}" target="_blank">
                        <img class="img-fluid" src="{{ $registered_animal->thumbnail }}" alt=""
                          style="width: 40px; height: 40px; object-fit: cover;">
                      </a>
                    </td>
                    <td>
                      {{ $registered_animal->name }}
                    </td>
                    <td>
                      {{ $registered_animal->animalSpeciesFormatted }}
                    </td>
                    <td class="text-right">
                      <a class="btn btn-round btn-default"
                        href="{{ route('user.reports.create', ['registered_animal_id' => $registered_animal->id]) }}">{{ __('messages.global.i_lost_my_animal') }}</a>
                      <a class="btn btn-round btn-success"
                        href="{{ route('user.registered_animals.show', $registered_animal) }}">{{ __('messages.global.show') }}</a>
                      <a class="btn btn-round btn-warning"
                        href="{{ route('user.registered_animals.edit', $registered_animal) }}">{{ __('messages.global.edit') }}</a>
                      <a class="btn btn-round btn-danger" href="#" data-toggle="modal"
                        data-target="#confirm-delete-registered_animal-dialog"
                        data-href="{{ route('user.registered_animals.delete', $registered_animal) }}">{{ __('messages.global.delete') }}</a>
                    </td>
                  </tr>
                @empty
                  <tr>
                    <td colspan="5">
                      {{ __('messages.global.no_registered_animals') }}
                    </td>
                  </tr>
                @endforelse
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>

  {{-- Confirm Delete Dialog --}}
  @include('user::_layouts.authenticated._partials.confirm_delete_dialog')

@endsection
